close all

%% DATA
m_s=2600;
Ixx=658;
Iyy=4174;
a=1.415;
b=3.25-1.415;
l=1.55/2;
m_f=150;     % m_fr=m_fl=150
m_r=100;     % m_rr=m_rl=100

ks_f=198000/2;     % ks_fr=ks_fl=198000/2
ks_r=130000/2;     % ks_rr=ks_rl=198000/2
cs_f=12500/2;    % cs_fl=cs_fr=12500/2
cs_r=12500/2;    % cs_rr=cs_rl=12500/2
ku=250000;    % ku_fr=ku_fl=ku_rr=ku_rl=ku
m_b=120;

%% Point 1
xb=(2270-1415)/1000;
yb=0.43;

%% Point 2
% xb=(667+2270-1415)/1000;
% yb=0.43;

%% keep c_b constant, varying k_b, finding the optimum k_b. 
c_b=300;
k_b=2000;
k_b1=5000;
k_b2=8000;
k_b3=10000;

M=[m_b 0   0   0   0   0   0   0;
   0   m_s 0   0   0   0   0   0;
   0   0   Iyy 0   0   0   0   0;
   0   0   0   Ixx 0   0   0   0;
   0   0   0   0   m_f 0   0   0;
   0   0   0   0   0   m_f 0   0;
   0   0   0   0   0   0   m_r 0;
   0   0   0   0   0   0   0   m_r];

K=[k_b     -k_b                     -k_b*xb                        k_b*yb                         0       0       0       0;
   -k_b    k_b+ks_f*2+ks_r*2        k_b*xb-ks_f*a*2+b*ks_r*2       -k_b*yb                        -ks_f   -ks_f   -ks_r   -ks_r;
   -k_b*xb k_b*xb-2*ks_f*a+2*ks_r*b k_b*xb^2+2*ks_f*a^2+2*ks_r*b^2 -k_b*xb*yb                     ks_f*a  ks_f*a  -ks_r*b -ks_r*b;
   k_b*yb  -k_b*yb                 -k_b*xb*yb                      k_b*yb^2+2*ks_f*l^2+2*ks_r*l^2 -ks_f*l ks_f*l  ks_r*l  -ks_r*l;
   0       -ks_f                    ks_f*a                         -ks_f*l                        ks_f+ku 0       0       0;
   0       -ks_f                    ks_f*a                         ks_f*l                         0       ks_f+ku 0       0;
   0       -ks_r                    -ks_r*b                        ks_r*l                         0       0       ks_r+ku 0;
   0       -ks_r                    -ks_r*b                        -ks_r*l                        0       0       0       ks_r+ku];

C=[c_b     -c_b                      -c_b*xb                        c_b*yb                         0       0       0       0;
   -c_b    c_b+cs_f*2+cs_r*2        c_b*xb-cs_f*a*2+b*cs_r*2       -c_b*yb                        -cs_f   -cs_f   -cs_r   -cs_r;
   -c_b*xb c_b*xb-2*cs_f*a+2*cs_r*b c_b*xb^2+2*cs_f*a^2+2*cs_r*b^2 -c_b*xb*yb                     cs_f*a  cs_f*a  -cs_r*b -cs_r*b;
   c_b*yb  -c_b*yb                  -c_b*xb*yb                      c_b*yb^2+2*cs_f*l^2+2*cs_r*l^2 -cs_f*l cs_f*l  cs_r*l  -cs_r*l;
   0       -cs_f                    cs_f*a                         -cs_f*l                        cs_f    0    0    0;
   0       -cs_f                    cs_f*a                         cs_f*l                         0       cs_f 0    0;
   0       -cs_r                    -cs_r*b                        cs_r*l                         0       0    cs_r 0;
   0       -cs_r                    -cs_r*b                        -cs_r*l                        0       0    0    cs_r];

K1=[k_b1     -k_b1                     -k_b1*xb                        k_b1*yb                         0       0       0       0;
   -k_b1    k_b1+ks_f*2+ks_r*2        k_b1*xb-ks_f*a*2+b*ks_r*2       -k_b1*yb                        -ks_f   -ks_f   -ks_r   -ks_r;
   -k_b1*xb k_b1*xb-2*ks_f*a+2*ks_r*b k_b1*xb^2+2*ks_f*a^2+2*ks_r*b^2 -k_b1*xb*yb                     ks_f*a  ks_f*a  -ks_r*b -ks_r*b;
   k_b1*yb  -k_b1*yb                 -k_b1*xb*yb                      k_b1*yb^2+2*ks_f*l^2+2*ks_r*l^2 -ks_f*l ks_f*l  ks_r*l  -ks_r*l;
   0       -ks_f                    ks_f*a                         -ks_f*l                        ks_f+ku 0       0       0;
   0       -ks_f                    ks_f*a                         ks_f*l                         0       ks_f+ku 0       0;
   0       -ks_r                    -ks_r*b                        ks_r*l                         0       0       ks_r+ku 0;
   0       -ks_r                    -ks_r*b                        -ks_r*l                        0       0       0       ks_r+ku];

K2=[k_b2     -k_b2                     -k_b2*xb                        k_b2*yb                         0       0       0       0;
   -k_b2    k_b2+ks_f*2+ks_r*2        k_b2*xb-ks_f*a*2+b*ks_r*2       -k_b2*yb                        -ks_f   -ks_f   -ks_r   -ks_r;
   -k_b2*xb k_b2*xb-2*ks_f*a+2*ks_r*b k_b2*xb^2+2*ks_f*a^2+2*ks_r*b^2 -k_b2*xb*yb                     ks_f*a  ks_f*a  -ks_r*b -ks_r*b;
   k_b2*yb  -k_b2*yb                 -k_b2*xb*yb                      k_b2*yb^2+2*ks_f*l^2+2*ks_r*l^2 -ks_f*l ks_f*l  ks_r*l  -ks_r*l;
   0       -ks_f                    ks_f*a                         -ks_f*l                        ks_f+ku 0       0       0;
   0       -ks_f                    ks_f*a                         ks_f*l                         0       ks_f+ku 0       0;
   0       -ks_r                    -ks_r*b                        ks_r*l                         0       0       ks_r+ku 0;
   0       -ks_r                    -ks_r*b                        -ks_r*l                        0       0       0       ks_r+ku];

K3=[k_b3     -k_b3                     -k_b3*xb                        k_b3*yb                         0       0       0       0;
   -k_b3    k_b3+ks_f*2+ks_r*2        k_b3*xb-ks_f*a*2+b*ks_r*2       -k_b3*yb                        -ks_f   -ks_f   -ks_r   -ks_r;
   -k_b3*xb k_b3*xb-2*ks_f*a+2*ks_r*b k_b3*xb^2+2*ks_f*a^2+2*ks_r*b^2 -k_b3*xb*yb                     ks_f*a  ks_f*a  -ks_r*b -ks_r*b;
   k_b3*yb  -k_b3*yb                 -k_b3*xb*yb                      k_b3*yb^2+2*ks_f*l^2+2*ks_r*l^2 -ks_f*l ks_f*l  ks_r*l  -ks_r*l;
   0       -ks_f                    ks_f*a                         -ks_f*l                        ks_f+ku 0       0       0;
   0       -ks_f                    ks_f*a                         ks_f*l                         0       ks_f+ku 0       0;
   0       -ks_r                    -ks_r*b                        ks_r*l                         0       0       ks_r+ku 0;
   0       -ks_r                    -ks_r*b                        -ks_r*l                        0       0       0       ks_r+ku];

%% keep k_b its optimum value, varying c_b, finding the optimum c_b. 
k_b=2000;
c_b1=250;
c_b2=300;
c_b3=350;
c_b4=400;
c_b5=450;
c_b6=500;

M=[m_b 0   0   0   0   0   0   0;
   0   m_s 0   0   0   0   0   0;
   0   0   Iyy 0   0   0   0   0;
   0   0   0   Ixx 0   0   0   0;
   0   0   0   0   m_f 0   0   0;
   0   0   0   0   0   m_f 0   0;
   0   0   0   0   0   0   m_r 0;
   0   0   0   0   0   0   0   m_r];

K=[k_b     -k_b                     -k_b*xb                        k_b*yb                         0       0       0       0;
   -k_b    k_b+ks_f*2+ks_r*2        k_b*xb-ks_f*a*2+b*ks_r*2       -k_b*yb                        -ks_f   -ks_f   -ks_r   -ks_r;
   -k_b*xb k_b*xb-2*ks_f*a+2*ks_r*b k_b*xb^2+2*ks_f*a^2+2*ks_r*b^2 -k_b*xb*yb                     ks_f*a  ks_f*a  -ks_r*b -ks_r*b;
   k_b*yb  -k_b*yb                 -k_b*xb*yb                      k_b*yb^2+2*ks_f*l^2+2*ks_r*l^2 -ks_f*l ks_f*l  ks_r*l  -ks_r*l;
   0       -ks_f                    ks_f*a                         -ks_f*l                        ks_f+ku 0       0       0;
   0       -ks_f                    ks_f*a                         ks_f*l                         0       ks_f+ku 0       0;
   0       -ks_r                    -ks_r*b                        ks_r*l                         0       0       ks_r+ku 0;
   0       -ks_r                    -ks_r*b                        -ks_r*l                        0       0       0       ks_r+ku];

C1=[c_b1     -c_b1                     -c_b1*xb                        c_b1*yb                         0       0       0       0;
   -c_b1    c_b1+cs_f*2+cs_r*2        c_b1*xb-cs_f*a*2+b*cs_r*2       -c_b1*yb                        -cs_f   -cs_f   -cs_r   -cs_r;
   -c_b1*xb c_b1*xb-2*cs_f*a+2*cs_r*b c_b1*xb^2+2*cs_f*a^2+2*cs_r*b^2 -c_b1*xb*yb                     cs_f*a  cs_f*a  -cs_r*b -cs_r*b;
   c_b1*yb  -c_b1*yb                  -c_b1*xb*yb                      c_b1*yb^2+2*cs_f*l^2+2*cs_r*l^2 -cs_f*l cs_f*l  cs_r*l  -cs_r*l;
   0       -cs_f                    cs_f*a                         -cs_f*l                        cs_f    0    0    0;
   0       -cs_f                    cs_f*a                         cs_f*l                         0       cs_f 0    0;
   0       -cs_r                    -cs_r*b                        cs_r*l                         0       0    cs_r 0;
   0       -cs_r                    -cs_r*b                        -cs_r*l                        0       0    0    cs_r];

C2=[c_b2     -c_b2                     -c_b2*xb                        c_b2*yb                         0       0       0       0;
   -c_b2    c_b2+cs_f*2+cs_r*2        c_b2*xb-cs_f*a*2+b*cs_r*2       -c_b2*yb                        -cs_f   -cs_f   -cs_r   -cs_r;
   -c_b2*xb c_b2*xb-2*cs_f*a+2*cs_r*b c_b2*xb^2+2*cs_f*a^2+2*cs_r*b^2 -c_b2*xb*yb                     cs_f*a  cs_f*a  -cs_r*b -cs_r*b;
   c_b2*yb  -c_b2*yb                 -c_b2*xb*yb                      c_b2*yb^2+2*cs_f*l^2+2*cs_r*l^2 -cs_f*l cs_f*l  cs_r*l  -cs_r*l;
   0       -cs_f                    cs_f*a                         -cs_f*l                        cs_f    0    0    0;
   0       -cs_f                    cs_f*a                         cs_f*l                         0       cs_f 0    0;
   0       -cs_r                    -cs_r*b                        cs_r*l                         0       0    cs_r 0;
   0       -cs_r                    -cs_r*b                        -cs_r*l                        0       0    0    cs_r];
 

C3=[c_b3     -c_b3                     -c_b3*xb                        c_b3*yb                         0       0       0       0;
   -c_b3    c_b3+cs_f*2+cs_r*2        c_b3*xb-cs_f*a*2+b*cs_r*2       -c_b3*yb                        -cs_f   -cs_f   -cs_r   -cs_r;
   -c_b3*xb c_b3*xb-2*cs_f*a+2*cs_r*b c_b3*xb^2+2*cs_f*a^2+2*cs_r*b^2 -c_b3*xb*yb                     cs_f*a  cs_f*a  -cs_r*b -cs_r*b;
   c_b3*yb  -c_b3*yb                 -c_b3*xb*yb                      c_b3*yb^2+2*cs_f*l^2+2*cs_r*l^2 -cs_f*l cs_f*l  cs_r*l  -cs_r*l;
   0       -cs_f                    cs_f*a                         -cs_f*l                        cs_f    0    0    0;
   0       -cs_f                    cs_f*a                         cs_f*l                         0       cs_f 0    0;
   0       -cs_r                    -cs_r*b                        cs_r*l                         0       0    cs_r 0;
   0       -cs_r                    -cs_r*b                        -cs_r*l                        0       0    0    cs_r];


C4=[c_b4     -c_b4                     -c_b4*xb                        c_b4*yb                         0       0       0       0;
   -c_b4    c_b4+cs_f*2+cs_r*2        c_b4*xb-cs_f*a*2+b*cs_r*2       -c_b4*yb                        -cs_f   -cs_f   -cs_r   -cs_r;
   -c_b4*xb c_b4*xb-2*cs_f*a+2*cs_r*b c_b4*xb^2+2*cs_f*a^2+2*cs_r*b^2 -c_b4*xb*yb                     cs_f*a  cs_f*a  -cs_r*b -cs_r*b;
   c_b4*yb  -c_b4*yb                 -c_b4*xb*yb                      c_b4*yb^2+2*cs_f*l^2+2*cs_r*l^2 -cs_f*l cs_f*l  cs_r*l  -cs_r*l;
   0       -cs_f                    cs_f*a                         -cs_f*l                        cs_f    0    0    0;
   0       -cs_f                    cs_f*a                         cs_f*l                         0       cs_f 0    0;
   0       -cs_r                    -cs_r*b                        cs_r*l                         0       0    cs_r 0;
   0       -cs_r                    -cs_r*b                        -cs_r*l                        0       0    0    cs_r];

C5=[c_b5     -c_b5                     -c_b5*xb                        c_b5*yb                         0       0       0       0;
   -c_b5    c_b5+cs_f*2+cs_r*2        c_b5*xb-cs_f*a*2+b*cs_r*2       -c_b5*yb                        -cs_f   -cs_f   -cs_r   -cs_r;
   -c_b5*xb c_b5*xb-2*cs_f*a+2*cs_r*b c_b5*xb^2+2*cs_f*a^2+2*cs_r*b^2 -c_b5*xb*yb                     cs_f*a  cs_f*a  -cs_r*b -cs_r*b;
   c_b5*yb  -c_b5*yb                 -c_b5*xb*yb                      c_b5*yb^2+2*cs_f*l^2+2*cs_r*l^2 -cs_f*l cs_f*l  cs_r*l  -cs_r*l;
   0       -cs_f                    cs_f*a                         -cs_f*l                        cs_f    0    0    0;
   0       -cs_f                    cs_f*a                         cs_f*l                         0       cs_f 0    0;
   0       -cs_r                    -cs_r*b                        cs_r*l                         0       0    cs_r 0;
   0       -cs_r                    -cs_r*b                        -cs_r*l                        0       0    0    cs_r];

C6=[c_b6     -c_b6                     -c_b6*xb                        c_b6*yb                         0       0       0       0;
   -c_b6    c_b6+cs_f*2+cs_r*2        c_b6*xb-cs_f*a*2+b*cs_r*2       -c_b6*yb                        -cs_f   -cs_f   -cs_r   -cs_r;
   -c_b6*xb c_b6*xb-2*cs_f*a+2*cs_r*b c_b6*xb^2+2*cs_f*a^2+2*cs_r*b^2 -c_b6*xb*yb                     cs_f*a  cs_f*a  -cs_r*b -cs_r*b;
   c_b6*yb  -c_b6*yb                 -c_b6*xb*yb                      c_b6*yb^2+2*cs_f*l^2+2*cs_r*l^2 -cs_f*l cs_f*l  cs_r*l  -cs_r*l;
   0       -cs_f                    cs_f*a                         -cs_f*l                        cs_f    0    0    0;
   0       -cs_f                    cs_f*a                         cs_f*l                         0       cs_f 0    0;
   0       -cs_r                    -cs_r*b                        cs_r*l                         0       0    cs_r 0;
   0       -cs_r                    -cs_r*b                        -cs_r*l                        0       0    0    cs_r];

%% Parameters of sin signal
w=2*pi/(6.5/(30/3.6));
phi_front=-(2*pi/(6.5/(30/3.6)))*(6.5/4/(30/3.6));
phi_rear=(2*pi/(6.5/(30/3.6)))*(3.25/(30/3.6))-(2*pi/(6.5/(30/3.6)))*(6.5/4/(30/3.6));

%% RMS of Zb varying Kb and Cb
kb=2000;
for cb3=50:20:1000

    Kv=[kb     -kb                     -kb*xb                        kb*yb                         0       0       0       0;
   -kb    kb+ks_f*2+ks_r*2        kb*xb-ks_f*a*2+b*ks_r*2       -kb*yb                        -ks_f   -ks_f   -ks_r   -ks_r;
   -kb*xb kb*xb-2*ks_f*a+2*ks_r*b kb*xb^2+2*ks_f*a^2+2*ks_r*b^2 -kb*xb*yb                     ks_f*a  ks_f*a  -ks_r*b -ks_r*b;
   kb*yb  -kb*yb                 -kb*xb*yb                      kb*yb^2+2*ks_f*l^2+2*ks_r*l^2 -ks_f*l ks_f*l  ks_r*l  -ks_r*l;
   0       -ks_f                    ks_f*a                         -ks_f*l                        ks_f+ku 0       0       0;
   0       -ks_f                    ks_f*a                         ks_f*l                         0       ks_f+ku 0       0;
   0       -ks_r                    -ks_r*b                        ks_r*l                         0       0       ks_r+ku 0;
   0       -ks_r                    -ks_r*b                        -ks_r*l                        0       0       0       ks_r+ku];

    Cv=[cb3     -cb3                     -cb3*xb                        cb3*yb                         0       0       0       0;
   -cb3    cb3+cs_f*2+cs_r*2        cb3*xb-cs_f*a*2+b*cs_r*2       -cb3*yb                        -cs_f   -cs_f   -cs_r   -cs_r;
   -cb3*xb cb3*xb-2*cs_f*a+2*cs_r*b cb3*xb^2+2*cs_f*a^2+2*cs_r*b^2 -cb3*xb*yb                     cs_f*a  cs_f*a  -cs_r*b -cs_r*b;
   cb3*yb  -cb3*yb                 -cb3*xb*yb                      cb3*yb^2+2*cs_f*l^2+2*cs_r*l^2 -cs_f*l cs_f*l  cs_r*l  -cs_r*l;
   0       -cs_f                    cs_f*a                         -cs_f*l                        cs_f    0    0    0;
   0       -cs_f                    cs_f*a                         cs_f*l                         0       cs_f 0    0;
   0       -cs_r                    -cs_r*b                        cs_r*l                         0       0    cs_r 0;
   0       -cs_r                    -cs_r*b                        -cs_r*l                        0       0    0    cs_r];


m = sim('sin_road.slx','SimulationMode','normal');
n = m.get('Zb');
n1 = m.get('Zb1');
assignin('base','g',n);
assignin('base','g',n1);
RMS1 = sqrt(mean(sum(n.*n))) %RMS value from time domain samples 
RMS2 = sqrt(mean(sum(n1.*n1))) %RMS value from time domain samples 

hold on
plot(cb3,RMS2,'*',cb3,RMS1,'.')
grid
hold off
end

%% Optimum kb and cb for random road
% cb3=250;
% kb=2000;
% 
%     Kop=[kb     -kb                     -kb*xb                        kb*yb                         0       0       0       0;
%    -kb    kb+ks_f*2+ks_r*2        kb*xb-ks_f*a*2+b*ks_r*2       -kb*yb                        -ks_f   -ks_f   -ks_r   -ks_r;
%    -kb*xb kb*xb-2*ks_f*a+2*ks_r*b kb*xb^2+2*ks_f*a^2+2*ks_r*b^2 -kb*xb*yb                     ks_f*a  ks_f*a  -ks_r*b -ks_r*b;
%    kb*yb  -kb*yb                 -kb*xb*yb                      kb*yb^2+2*ks_f*l^2+2*ks_r*l^2 -ks_f*l ks_f*l  ks_r*l  -ks_r*l;
%    0       -ks_f                    ks_f*a                         -ks_f*l                        ks_f+ku 0       0       0;
%    0       -ks_f                    ks_f*a                         ks_f*l                         0       ks_f+ku 0       0;
%    0       -ks_r                    -ks_r*b                        ks_r*l                         0       0       ks_r+ku 0;
%    0       -ks_r                    -ks_r*b                        -ks_r*l                        0       0       0       ks_r+ku];
% 
%     Cop=[cb3     -cb3                     -cb3*xb                        cb3*yb                         0       0       0       0;
%    -cb3    cb3+cs_f*2+cs_r*2        cb3*xb-cs_f*a*2+b*cs_r*2       -cb3*yb                        -cs_f   -cs_f   -cs_r   -cs_r;
%    -cb3*xb cb3*xb-2*cs_f*a+2*cs_r*b cb3*xb^2+2*cs_f*a^2+2*cs_r*b^2 -cb3*xb*yb                     cs_f*a  cs_f*a  -cs_r*b -cs_r*b;
%    cb3*yb  -cb3*yb                 -cb3*xb*yb                      cb3*yb^2+2*cs_f*l^2+2*cs_r*l^2 -cs_f*l cs_f*l  cs_r*l  -cs_r*l;
%    0       -cs_f                    cs_f*a                         -cs_f*l                        cs_f    0    0    0;
%    0       -cs_f                    cs_f*a                         cs_f*l                         0       cs_f 0    0;
%    0       -cs_r                    -cs_r*b                        cs_r*l                         0       0    cs_r 0;
%    0       -cs_r                    -cs_r*b                        -cs_r*l                        0       0    0    cs_r];